@csrf

<div class="row">
    <div class="col-md-6">
        <h5>Sender Information</h5>

        <label for="sender_name">Sender Name</label>
        <input id="sender_name" name="sender_name" class="form-control mb-2" placeholder="Sender Name"
            value="{{ old('sender_name', $courier->sender_name ?? '') }}" required>

        <label for="sender_email">Sender Email</label>
        <input id="sender_email" name="sender_email" type="email" class="form-control mb-2" placeholder="Sender Email"
            value="{{ old('sender_email', $courier->sender_email ?? '') }}" required>

        <label for="sender_address">Sender Address</label>
        <textarea id="sender_address" name="sender_address" class="form-control mb-2" placeholder="Sender Address" required>{{ old('sender_address', $courier->sender_address ?? '') }}</textarea>
    </div>

    <div class="col-md-6">
        <h5>Receiver Information</h5>

        <label for="receiver_name">Receiver Name</label>
        <input id="receiver_name" name="receiver_name" class="form-control mb-2" placeholder="Receiver Name"
            value="{{ old('receiver_name', $courier->receiver_name ?? '') }}" required>

        <label for="receiver_email">Receiver Email</label>
        <input id="receiver_email" name="receiver_email" type="email" class="form-control mb-2"
            placeholder="Receiver Email" value="{{ old('receiver_email', $courier->receiver_email ?? '') }}" required>

        <label for="receiver_contact">contact</label>
        <input   id="receiver_contact" name="receiver_contact" class="form-control mb-2" placeholder="Contact"
            value="{{ old('receiver_contact', $courier->receiver_contact ?? '') }}" required>

        <label for="receiver_address">Receiver Address</label>
        <textarea id="receiver_address" name="receiver_address" class="form-control mb-2" placeholder="Receiver Address" required>{{ old('receiver_address', $courier->receiver_address ?? '') }}</textarea>
    </div>
</div>

<hr>

<h5>Package Details</h5>

{{-- <label for="description">Package Description</label> --}}
<textarea id="description" name="description" class="form-control mb-2" placeholder="Package Description">{{ old('description', $courier->description ?? '') }}</textarea>

<label for="quantity">tracking number</label>
<input id="tracking_code" name="tracking_code" type="text" class="form-control mb-2" placeholder="Tracking Code"
    value="{{ old('tracking_code', $courier->tracking_code ?? "$tracking_code" ) }}" required>

<label for="quantity">Quantity</label>
<input id="quantity" name="quantity" type="number" class="form-control mb-2" placeholder="Quantity"
    value="{{ old('quantity', $courier->quantity ?? 1) }}" required>

<label for="weight">Weight (kg)</label>
<input id="weight" name="weight"  type="number" class="form-control mb-2" placeholder="Weight (kg)"
    value="{{ old('weight', $courier->weight ?? '0.9') }}">

    <label for="weight">payment_mode</label>
<input id="payment_mode" name="payment_mode"  type="text" class="form-control mb-2" placeholder="payment mode"
    value="{{ old('payment_mode', $courier->payment_mode ?? 'Bitcoin') }}">


    <label for="shipping_mode">Shipping Mode</label>
<select id="shipping_mode" name="shipping_mode" class="form-control mb-2">
    <option value="{{ $courier->shipping_mode ?? 'Air Freight' }}">
        {{ $courier->shipping_mode ?? 'Air Freight' }}
    </option>
    <option value="Air Freight">Air Freight</option>
    <option value="Sea Freight">Sea Freight</option>
    <option value="Road Freight">Road Freight</option>
    <option value="Rail Freight">Rail Freight</option>
</select>


<h5>Location & Delivery</h5>

<label for="origin">Origin</label>
<input id="origin" name="origin" class="form-control mb-2" placeholder="Origin"
    value="{{ old('origin', $courier->origin ?? '') }}" required>

<label for="current_location">Current Location</label>
<input id="current_location" name="current_location" class="form-control mb-2" placeholder="Current Location"
    value="{{ old('current_location', $courier->current_location ?? '') }}">

<label for="destination">Destination</label>
<input id="destination" name="destination" class="form-control mb-2" placeholder="Destination"
    value="{{ old('destination', $courier->destination ?? '') }}" required>

<label for="freight_cost">Freight Cost</label>
<input id="freight_cost" name="freight_cost" class="form-control mb-2" placeholder="Freight Cost"
    value="{{ old('freight_cost', $courier->freight_cost ?? '') }}">

<label for="estimated_delivery">Estimated Delivery Date</label>
<input id="estimated_delivery" name="estimated_delivery" type="date" class="form-control mb-2"
    value="{{ old('estimated_delivery', $courier->estimated_delivery ?? '') }}">

<label for="dispatch_date">Dispatch Date</label>
<input id="dispatch_date" name="dispatch_date" type="date" class="form-control mb-2"
    value="{{ old('dispatch_date', $courier->dispatch_date ?? '') }}">

<h5>Status</h5>

<label for="status">Shipment Status</label>
<select id="status" name="status" class="form-control " required>
    @php
        $statuses = [
            'Approved', 'Available', 'Cancelled', 'Customs', 'Delivered', 'Dispenser',
            'Distribution', 'Earring Collection', 'Effective', 'In Transit', 'In warehouse',
            'Invoiced', 'On Hold', 'On route', 'Packaged', 'Pending'
        ];
        $selectedStatus = old('status', $courier->status ?? '');
    @endphp

    @foreach($statuses as $status)
        <option value="{{ $status }}" {{ $selectedStatus === $status ? 'selected' : '' }}>
            {{ $status }}
        </option>
    @endforeach
</select>




<label for="shipment_progress">Shipment Progress (e.g. 60%)</label>
<input id="shipment_progress" name="shipment_progress" class="form-control mb-2"
    placeholder="Shipment Progress e.g. 60%" value="{{ old('shipment_progress', $courier->shipment_progress ?? '') }}">

<div class="form-check mb-2">
    <input id="delivery_completion" name="delivery_completion" type="checkbox" class="form-check-input"
        {{ old('delivery_completion', $courier->delivery_completion ?? false) ? 'checked' : '' }}>
    {{-- <label for="delivery_completion" class="form-check-label">Mark as Delivered</label> --}}
</div>

<h5>Photo</h5>
@if(isset($courier) && $courier->photo)
    <img src="{{ asset('storage/app/public/' . $courier->photo) }}" width="100" class="mb-2"><br>
@endif

<label for="photo">Upload New Photo</label>
<input id="photo" type="file" name="photo" class="form-control mb-3">

<button type="submit" class="btn btn-success">Save</button>
