@extends('layouts.app')

@section('content')
@include('admin.topmenu')
@include('admin.sidebar')

<div class="main-panel">
    <div class="content">
        <div class="page-inner">
            <div class="d-flex justify-content-between align-items-center mt-2 mb-4">
                <h2>All Shipments</h2>
                <a class="btn btn-primary btn-sm" href="{{ route('couriers.index') }}">
                    <i class="fa fa-arrow-left"></i> Back
                </a>
            </div>

            <x-danger-alert />
            <x-success-alert />

            <a href="{{ route('couriers.create') }}" class="btn btn-primary mb-3">Create New Shipment</a>

            <div class="table-responsive">

                  <style>
    .marquee-container {
      background-color: #fff3cd;
      color: #856404;
      border: 1px solid #ffeeba;
      padding: 10px 20px;
      font-family: Arial, sans-serif;
      font-size: 16px;
      position: relative;
      overflow: hidden;
      height: 50px;
    }

    .marquee-text {
      white-space: nowrap;
      display: inline-block;
      animation: marquee 15s linear infinite;
    }

    @keyframes marquee {
      0% { transform: translateX(100%); }
      100% { transform: translateX(-100%); }
    }
  </style>
   <div class="marquee-container">
    <div class="marquee-text">
      🚨 Note: To turn on Customs Clearance Document Required Notification you need to update shipment status to Customs
    </div>
  </div>
                <table class="table table-bordered table-hover">
                    <thead class="thead-light">
                        <tr>
                            <th>Tracking Code</th>
                            <th>Sender</th>
                            <th>Receiver</th>
                            <th>Status</th>
                            <th>Origin → Destination</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($couriers as $courier)
                        <tr>
                            <td>{{ $courier->tracking_code }}</td>
                            <td>{{ $courier->sender_name }}</td>
                            <td>{{ $courier->receiver_name }}</td>
                            <td>{{ $courier->status }}</td>
                            <td>{{ $courier->origin }} → {{ $courier->destination }}</td>
                            <td>
                                <a href="{{ route('couriers.show', $courier->id) }}" class="btn btn-sm btn-info">Update</a>
                                <a href="{{ route('couriers.edit', $courier->id) }}" class="btn btn-sm btn-warning">Edit</a>
                                <form action="{{ route('couriers.destroy', $courier->id) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button onclick="return confirm('Delete shipment?')" class="btn btn-sm btn-danger">Delete</button>
                                </form>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <div class="mt-3">
                {{ $couriers->links() }}
            </div>
        </div>
    </div>
</div>
@endsection
