@component('mail::message')
# Shipment Created – Tracking {{ $courier->tracking_code }}

Dear {{ $courier->receiver_name }},

A shipment has been created for you.

**From:** {{ $courier->sender_name }} ({{ $courier->sender_email }})
**To:** {{ $courier->receiver_name }} ({{ $courier->receiver_email }})
**Origin:** {{ $courier->origin }}
**Destination:** {{ $courier->destination }}
**Status:** {{ $courier->status }}
**Estimated Delivery:** {{ \Carbon\Carbon::parse($courier->estimated_delivery)->toFormattedDateString() }}

@component('mail::button', ['url' => route('track.form')])
Track Your Shipment
@endcomponent

Thanks,
**{{ config('app.name') }} Team**
@endcomponent
{{-- This is a Blade template for the email notification sent when a courier is created. It includes details about the shipment and provides a button to track the shipment. --}}
