@extends('layouts.invoice')

@section('title', $settings->site_title)


@inject('content', 'App\Http\Controllers\FrontController')
@section('content')

  <body  style="background-color:teal;"  onload="window.print();">




    <div class="wrapper" id="background"> <p id="bg-text">Certified True Copy</p>

      <!-- Main content -->
      <section class="invoice" >
        <!-- title row -->
        <div class="row"  >
          <div class="col-xs-12">
            <h2 class="page-header">
			  <span><img src="{{ asset('storage/app/public/'.$settings->logo)}}"  height="45" width='130' >

			  <img class="pull-right"  src="{{ asset('temp/banner.png') }}" alt=""  height="185"/>

			  <h3 style="color:red;"><strong> Tracking Number: {{$user->tracking_code}}</strong>
			  </h3></span>

            </h2>
          </div><!-- /.col -->
        </div>

        <div class="row">
          <div class="col-xs-12">
            <h2 class="page-header">
			   <center>
			       <strong style="color:green;">{{$settings->site_name}} Logistics Company<br>
Address: Canada, USA, UK, Asia and Europe<br>
Email: {{$settings->contact_email}}<br>
Company Website:{{$settings->site_address}}</strong></center>
            </h2>
          </div><!-- /.col -->
        </div>


        <!-- info row -->
        <div class="row invoice-info">
          <div class="col-sm-4 invoice-col">
            <strong style="color:blue;">FROM (SENDER)</strong>
            <address>
              <h3><strong style="color:green;">{{$user->sender_name}}</strong></h3>

              <b>Address:</b> {{$user->sender_address}}<br/>
			  <b>Origin :</b> {{ $user->origin }}            </address>
          </div><!-- /.col -->
          <div class="col-sm-4 invoice-col">
            <strong style="color:blue;">TO (CONSIGNEE)</strong>
            <address>
              <h3><strong style="color:green;">{{$user->receiver_name}}</strong></h3>

              <b>Phone:</b> {{$user->receiver_contact}}<br/>
			  <b>Address:</b> {{$user->receiver_address}}<br/>
              <b>Destination Office:</b> {{ $user->destination }}           </address>
          </div><!-- /.col -->
          <div class="col-sm-4 invoice-col">
		  <table>
                                        	<tr>
                                                <td>
                                                    <center>
                                                      <img src="https://barcode.tec-it.com/barcode.ashx?data={{ $user->tracking_code }}&code=Code128" alt="{{ $user->tracking_code }}"><br>
                                                        {{-- <strong>{{$user->tracking_code}}</strong><br> --}}
                                                    </center>
                                                </td>

                                            </tr>
                                        </table>
			<br/>
            <b>Order ID:</b>&nbsp;&nbsp;{{ $user->id }} <br/>
			<b>Payment Mode:</b> <small class="label label-danger"><i class="fa fa-money"></i>&nbsp;{{$user->payment_mode}}</small><br/>
		<b>Shipment  Cost:</b>&nbsp;{{ $settings->s_currency }}&nbsp;{{ $user->freight_cost }}<br/>
    <b>Tracking Number:</b>&nbsp;&nbsp;{{ $user->tracking_code }} <br/>
  </div><!-- /.col -->
        </div><!-- /.row -->

        <!-- Table row -->
        <div class="row">
          <div class="col-xs-12 table-responsive">
            <table class="table table-striped">
              <thead>
                <tr>
                  <th>Qty</th>
                  <th>Product</th>
                  <th>Status</th>
                  <th>Description</th>
				  <th>Shipping Cost</th>
                  <th>Clearance Cost</th>
                  <th>Total Cost</th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td>{{$user->quantity }}</td>
                  <td>Parcel</td>
                  <td><small class="label label-success">{{ $user->status }} </small></td>
                  <td>{{ $user->description }} </td>
				  <td>{{ $settings->s_currency }}&nbsp;{{ $user->freight_cost }} </td>
				  <td>{{ $settings->s_currency }}&nbsp;{{ $user->freight_cost*3 }}</td>
                  <td>{{ $settings->s_currency }}&nbsp;{{ $user->clearance_cost+($user->freight_cost*3) }}</td>
                </tr>
              </tbody>
            </table>
          </div><!-- /.col -->
        </div><!-- /.row -->
		<br>
		<br>
        <div class="row">
          <!-- accepted payments column -->
          <div class="col-xs-4">
            <p class="lead"><strong>Payment Methods:</strong></p>
            <img src="{{ asset('temp/securepayment.png') }}" alt="Methods payments" />
            <p class="text-muted well well-sm no-shadow" style="margin-top: 10px;">
              For your convenience we have {{ $settings->site_name }} several payment reliable, fast, secure.
            </p>

          </div>

          <div class="col-xs-4">
            <p class="lead"><strong>Official Stamp/{{ \Carbon\Carbon::parse($user->created_at)->toDayDateTimeString() }}</strong></p>
            <img src=" {{ asset('temp/stamp1.png') }}" alt="" height="100" />

          </div>
          <div class="col-xs-4">
            <p class="lead">Stamp Duty:</p>
            <img  class='text-center' src="{{ asset('temp/stamp2.png') }}" alt=""  height="100"/>

          </div>



          <!-- /.col -->
          <div class="col-xs-6">
            <p class="lead"><strong>Amount Due </strong></p>
            <div class="table-responsive">
              <table class="table">
                <tr>
                  <th style="width:50%">SHIPPING COST:</th>
                  <th>CLEARANCE COST:</th>
                  <th>TOTAL AMOUNT:</th>
                </tr>
                <tr>
                  <td>{{ $settings->s_currency }}&nbsp;{{ $user->freight_cost }}</td>
                  <td>{{ $settings->s_currency }}&nbsp;{{ $user->freight_cost*3 }}</td>
                  <td>{{ $settings->s_currency }}&nbsp;{{ $user->clearance_cost+($user->freight_cost*3) }}</td>
                </tr>

              </table>
            </div>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </section><!-- /.content -->
    </div><!-- ./wrapper -->

    @endsection
