<?php $__env->startSection('title', $settings->site_title); ?>


<?php $content = app('App\Http\Controllers\FrontController'); ?>
<?php $__env->startSection('content'); ?>






    <!-- Page Content -->
    <main class="flex-grow">
        <div class="animate-fade-in">
                <!-- Hero Slider Section -->
    <section class="relative overflow-hidden">
        <div class="hero-slider relative h-[600px] md:h-[700px]">
            <!-- Slide 1 -->
            <div class="hero-slide-item absolute inset-0 w-full h-full bg-cover bg-center" style="background-image: linear-gradient(rgba(26, 90, 64, 0.7), rgba(26, 90, 64, 0.7)), url('https://images.unsplash.com/photo-1586528116311-ad8dd3c8310d?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=2070&amp;q=80')">
                <div class="container mx-auto px-4 h-full flex items-center">
                    <div class="max-w-2xl text-white">
                        <h1 class="text-4xl md:text-6xl font-display font-bold mb-6 leading-tight">
                            Transport & <span class="text-gold-500">Logistics</span>
                        </h1>
                        <p class="text-xl mb-8 text-white text-opacity-90">
                            Take the complexity out of customs Freight Solutions with customs brokerage services
                        </p>
                        <a href="services" class="inline-flex items-center px-8 py-3 border border-transparent text-base font-medium rounded-md text-horizon-700 bg-gold-500 hover:bg-gold-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-gold-500 transition-colors duration-200">
                            COURIER SERVICE
                        </a>
                    </div>
                </div>
            </div>

            <!-- Slide 2 -->
            <div class="hero-slide-item absolute inset-0 w-full h-full bg-cover bg-center" style="background-image: linear-gradient(rgba(26, 90, 64, 0.7), rgba(26, 90, 64, 0.7)), url('https://images.unsplash.com/photo-1494412574643-ff11b0a5c1c3?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=2070&amp;q=80'); display: none;">
                <div class="container mx-auto px-4 h-full flex items-center">
                    <div class="max-w-2xl text-white">
                        <h1 class="text-4xl md:text-6xl font-display font-bold mb-6 leading-tight">
                            Quickest & Safe <span class="text-gold-500">Delivery</span>
                        </h1>
                        <p class="text-xl mb-8 text-white text-opacity-90">
                            Take the complexity out of customs Freight Solutions with customs brokerage services
                        </p>
                        <a href="services" class="inline-flex items-center px-8 py-3 border border-transparent text-base font-medium rounded-md text-horizon-700 bg-gold-500 hover:bg-gold-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-gold-500 transition-colors duration-200">
                            DISCOVER ALL
                        </a>
                    </div>
                </div>
            </div>

            <!-- Slide 3 -->
            <div class="hero-slide-item absolute inset-0 w-full h-full bg-cover bg-center" style="background-image: linear-gradient(rgba(26, 90, 64, 0.7), rgba(26, 90, 64, 0.7)), url('https://images.unsplash.com/photo-1566576912321-d58ddd7a6088?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=2070&amp;q=80'); display: none;">
                <div class="container mx-auto px-4 h-full flex items-center">
                    <div class="max-w-2xl text-white">
                        <h1 class="text-4xl md:text-6xl font-display font-bold mb-6 leading-tight">
                            Always <span class="text-gold-500">Trustable</span>
                        </h1>
                        <p class="text-xl mb-8 text-white text-opacity-90">
                            Take the complexity out of customs Freight Solutions with customs brokerage services
                        </p>
                        <a href="about" class="inline-flex items-center px-8 py-3 border border-transparent text-base font-medium rounded-md text-horizon-700 bg-gold-500 hover:bg-gold-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-gold-500 transition-colors duration-200">
                            MORE ABOUT US
                        </a>
                    </div>
                </div>
            </div>

            <!-- Slider Navigation -->
            <div class="absolute bottom-5 left-0 right-0 flex justify-center space-x-2">
                <button class="slider-dot w-3 h-3 rounded-full bg-white bg-opacity-50 focus:outline-none" data-slide="0"></button>
                <button class="slider-dot w-3 h-3 rounded-full bg-white bg-opacity-50 focus:outline-none" data-slide="1"></button>
                <button class="slider-dot w-3 h-3 rounded-full bg-white bg-opacity-50 focus:outline-none" data-slide="2"></button>
            </div>

            <!-- Navigation Arrows -->
            <button class="absolute left-4 top-1/2 transform -translate-y-1/2 w-12 h-12 bg-white bg-opacity-20 hover:bg-opacity-30 rounded-full flex items-center justify-center text-white transition-all duration-200" id="prev-slide">
                <i class="fas fa-chevron-left"></i>
            </button>
            <button class="absolute right-4 top-1/2 transform -translate-y-1/2 w-12 h-12 bg-white bg-opacity-20 hover:bg-opacity-30 rounded-full flex items-center justify-center text-white transition-all duration-200" id="next-slide">
                <i class="fas fa-chevron-right"></i>
            </button>
        </div>
    </section>

    <!-- Notice Section -->
    <section class="bg-gold-500 py-4">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center">
                <h6 class="text-horizon-800 font-medium">
                    <?php echo e($settings->site_name); ?> <strong>Logistics Facilities</strong> & Technical Support to Continue Operations as Essential Services
                </h6>
            </div>
        </div>
    </section>

    <!-- Video & Tracking Section -->
    <section class="py-16 bg-white">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
                <!-- Video Thumbnail -->
                <div class="relative">
                    <img src="temp/images/video-thumb.jpg" alt="Video Thumbnail" class="w-full h-auto rounded-lg shadow-lg">
                    <button class="absolute inset-0 flex items-center justify-center bg-black bg-opacity-30 hover:bg-opacity-40 transition-all duration-200 rounded-lg">
                        <div class="w-16 h-16 bg-gold-500 hover:bg-gold-600 rounded-full flex items-center justify-center text-white shadow-lg transition-colors duration-200">
                            <i class="fas fa-play text-xl ml-1"></i>
                        </div>
                    </button>
                </div>

                <!-- Tracking Form -->
                <div class="bg-horizon-700 rounded-lg p-8 text-white">
                      <?php $__errorArgs = ['tracking_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>

                     <div class="mb-6 bg-red-500/20 border border-red-300 text-white px-4 py-3 rounded-lg">
                            <i class="fas fa-exclamation-circle mr-2"></i> <?php echo e($message); ?>

                        </div>
                              <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    <h3 class="text-2xl font-display font-bold mb-6 mt-2 text-gold-400">Track Your Shipment</h3>
                    <form action="<?php echo e(route('track.search')); ?>" method="POST" class="space-y-4">
                         <?php echo csrf_field(); ?>
                        <div>
                            <input type="text" name="tracking_code" placeholder="Enter tracking number..." class="w-full px-4 py-3 bg-white bg-opacity-10 border border-white border-opacity-20 rounded-md text-white placeholder-white placeholder-opacity-70 focus:outline-none focus:ring-2 focus:ring-gold-500 focus:border-transparent">
                        </div>
                        <button type="submit" class="w-full px-6 py-3 bg-gold-500 hover:bg-gold-600 text-horizon-800 font-medium rounded-md transition-colors duration-200 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-gold-500">
                            <i class="fas fa-search mr-2"></i>
                            SEARCH
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </section>

    <!-- About Section -->
    <section class="py-16 bg-gray-50">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
                <!-- Content -->
                <div>
                    <h2 class="text-3xl md:text-4xl font-display font-bold text-horizon-800 mb-6">
                        Worldwide Logistics, Air Freight Forwarding, Road Haulage.
                    </h2>
                    <p class="text-secondary-700 mb-8 leading-relaxed">
                        <?php echo e($settings->site_name); ?> is a leading third party contract logistics company based in the Midlands, United Kingdom. We specialise in providing supply-chain warehousing and transport services throughout the UK, Ireland and Continental Europe.
                    </p>
                    <a href="services" class="inline-flex items-center px-6 py-3 border-2 border-horizon-700 text-base font-medium rounded-md text-horizon-700 bg-transparent hover:bg-horizon-700 hover:text-white focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-horizon-500 transition-colors duration-200">
                        Discover All Solutions
                    </a>
                </div>

                <!-- Image -->
                <div>
                    <img src="temp/images/side-image01.jpg" alt="Logistics Operations" class="w-full h-auto rounded-lg shadow-lg">
                </div>
            </div>
        </div>
    </section>

    <!-- Services Section -->
    <section class="py-16 bg-white">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <!-- Leadership -->
                <div class="bg-white rounded-lg shadow-sm border border-gray-100 p-8 text-center hover:shadow-md transition-shadow duration-300">
                    <div class="w-16 h-16 bg-gold-100 rounded-full flex items-center justify-center mx-auto mb-6">
                        <img src="temp/images/icon01.png" alt="Leadership" class="w-12 h-12">
                    </div>
                    <h3 class="text-xl font-semibold text-horizon-800 mb-4">Leadership</h3>
                    <p class="text-secondary-700 mb-6">
                        Experts who have extensive, hands-on experience in supply chain management
                    </p>
                    <a href="contact" class="text-gold-600 hover:text-gold-700 font-medium">
                        Connect with an Expert →
                    </a>
                </div>

                <!-- Technology -->
                <div class="bg-white rounded-lg shadow-sm border border-gray-100 p-8 text-center hover:shadow-md transition-shadow duration-300">
                    <div class="w-16 h-16 bg-gold-100 rounded-full flex items-center justify-center mx-auto mb-6">
                        <img src="temp/images/icon02.png" alt="Technology" class="w-12 h-12">
                    </div>
                    <h3 class="text-xl font-semibold text-horizon-800 mb-4">Technology</h3>
                    <p class="text-secondary-700 mb-6">
                        Innovative and varied use of technology on the road, ocean, railways, in the air.
                    </p>
                    <a href="contact" class="text-gold-600 hover:text-gold-700 font-medium">
                        Connect with an Expert →
                    </a>
                </div>

                <!-- Solution -->
                <div class="bg-white rounded-lg shadow-sm border border-gray-100 p-8 text-center hover:shadow-md transition-shadow duration-300">
                    <div class="w-16 h-16 bg-gold-100 rounded-full flex items-center justify-center mx-auto mb-6">
                        <img src="temp/images/icon03.png" alt="Solution" class="w-12 h-12">
                    </div>
                    <h3 class="text-xl font-semibold text-horizon-800 mb-4">Solution</h3>
                    <p class="text-secondary-700 mb-6">
                        Global leaders in intermodal, less-than-truckload, supply chain management.
                    </p>
                    <a href="contact" class="text-gold-600 hover:text-gold-700 font-medium">
                        Connect with an Expert →
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- Global Solutions Section -->
    <section class="py-16 bg-gray-50">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-12">
                <h2 class="text-3xl md:text-4xl font-display font-bold text-horizon-800 mb-4">
                    Global Supply Chain Solutions
                </h2>
                <p class="text-lg text-secondary-600 max-w-2xl mx-auto">
                    Dedicated specialists taking care of your products
                </p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <!-- Food & Beverage -->
                <div class="relative group overflow-hidden rounded-lg shadow-lg">
                    <img src="temp/images/solution-image01.jpg" alt="Food & Beverage" class="w-full h-64 object-cover group-hover:scale-105 transition-transform duration-300">
                    <div class="absolute inset-0 bg-gradient-to-t from-black via-transparent to-transparent opacity-70"></div>
                    <div class="absolute bottom-0 left-0 right-0 p-6 text-white">
                        <small class="text-gold-400 font-medium">Solutions</small>
                        <h3 class="text-xl font-semibold mb-2">Food & Beverage</h3>
                        <a href="#" class="text-gold-400 hover:text-gold-300">Discover More →</a>
                    </div>
                </div>

                <!-- Global 4PL -->
                <div class="relative group overflow-hidden rounded-lg shadow-lg">
                    <img src="temp/images/solution-image02.jpg" alt="Global 4PL" class="w-full h-64 object-cover group-hover:scale-105 transition-transform duration-300">
                    <div class="absolute inset-0 bg-gradient-to-t from-black via-transparent to-transparent opacity-70"></div>
                    <div class="absolute bottom-0 left-0 right-0 p-6 text-white">
                        <small class="text-gold-400 font-medium">Solutions</small>
                        <h3 class="text-xl font-semibold mb-2">Global 4PL</h3>
                        <a href="#" class="text-gold-400 hover:text-gold-300">Discover More →</a>
                    </div>
                </div>

                <!-- Consumer Packaged Goods -->
                <div class="relative group overflow-hidden rounded-lg shadow-lg md:col-span-2 lg:col-span-1">
                    <img src="temp/images/solution-image03.jpg" alt="Consumer Packaged Goods" class="w-full h-64 object-cover group-hover:scale-105 transition-transform duration-300">
                    <div class="absolute inset-0 bg-gradient-to-t from-black via-transparent to-transparent opacity-70"></div>
                    <div class="absolute bottom-0 left-0 right-0 p-6 text-white">
                        <small class="text-gold-400 font-medium">Solutions</small>
                        <h3 class="text-xl font-semibold mb-2">Consumer Packaged Goods</h3>
                        <a href="#" class="text-gold-400 hover:text-gold-300">Discover More →</a>
                    </div>
                </div>

                <!-- Transportation -->
                <div class="relative group overflow-hidden rounded-lg shadow-lg">
                    <img src="temp/images/solution-image04.jpg" alt="Transportation" class="w-full h-64 object-cover group-hover:scale-105 transition-transform duration-300">
                    <div class="absolute inset-0 bg-gradient-to-t from-black via-transparent to-transparent opacity-70"></div>
                    <div class="absolute bottom-0 left-0 right-0 p-6 text-white">
                        <small class="text-gold-400 font-medium">Solutions</small>
                        <h3 class="text-xl font-semibold mb-2">Transportation</h3>
                        <a href="#" class="text-gold-400 hover:text-gold-300">Discover More →</a>
                    </div>
                </div>

                <!-- Retails -->
                <div class="relative group overflow-hidden rounded-lg shadow-lg">
                    <img src="temp/images/solution-image05.jpg" alt="Retails" class="w-full h-64 object-cover group-hover:scale-105 transition-transform duration-300">
                    <div class="absolute inset-0 bg-gradient-to-t from-black via-transparent to-transparent opacity-70"></div>
                    <div class="absolute bottom-0 left-0 right-0 p-6 text-white">
                        <small class="text-gold-400 font-medium">Solutions</small>
                        <h3 class="text-xl font-semibold mb-2">Retails</h3>
                        <a href="#" class="text-gold-400 hover:text-gold-300">Discover More →</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Quality Services Section -->
    <section class="py-16 bg-white">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
                <!-- Services List -->
                <div>
                    <span class="text-gold-600 font-medium text-sm uppercase tracking-wide">Services</span>
                    <h2 class="text-3xl md:text-4xl font-display font-bold text-horizon-800 mt-2 mb-8">
                        Quality Delivered as Standard
                    </h2>
                    <ul class="space-y-4 mb-8">
                        <li>
                            <a href="#" class="flex items-center justify-between py-3 px-4 bg-gray-50 hover:bg-horizon-50 rounded-lg transition-colors duration-200">
                                <span class="text-horizon-800 font-medium">Forwarding</span>
                                <i class="fas fa-chevron-right text-gold-600"></i>
                            </a>
                        </li>
                        <li>
                            <a href="#" class="flex items-center justify-between py-3 px-4 bg-gray-50 hover:bg-horizon-50 rounded-lg transition-colors duration-200">
                                <span class="text-horizon-800 font-medium">Supply Chain</span>
                                <i class="fas fa-chevron-right text-gold-600"></i>
                            </a>
                        </li>
                        <li>
                            <a href="#" class="flex items-center justify-between py-3 px-4 bg-gray-50 hover:bg-horizon-50 rounded-lg transition-colors duration-200">
                                <span class="text-horizon-800 font-medium">Outsourcing</span>
                                <i class="fas fa-chevron-right text-gold-600"></i>
                            </a>
                        </li>
                        <li>
                            <a href="#" class="flex items-center justify-between py-3 px-4 bg-gray-50 hover:bg-horizon-50 rounded-lg transition-colors duration-200">
                                <span class="text-horizon-800 font-medium">Technology</span>
                                <i class="fas fa-chevron-right text-gold-600"></i>
                            </a>
                        </li>
                    </ul>
                    <a href="services" class="text-gold-600 hover:text-gold-700 font-medium">
                        View All Services →
                    </a>
                </div>

                <!-- Image with Info Box -->
                <div class="relative">
                    <img src="temp/images/side-image02.jpg" alt="Quality Services" class="w-full h-auto rounded-lg shadow-lg">
                    <div class="absolute top-6 left-6 bg-white p-6 rounded-lg shadow-lg max-w-xs">
                        <div class="flex items-start space-x-4">
                            <div class="w-12 h-12 bg-gold-100 rounded-full flex items-center justify-center flex-shrink-0">
                                <img src="temp/images/icon-infobox.png" alt="Info" class="w-8 h-8">
                            </div>
                            <div>
                                <p class="text-secondary-700 text-sm leading-relaxed">
                                    Personnel deliver bespoke solutions that are designed to increase speed to market, <strong>simplify inventory</strong> management, streamline product flow and drive down costs.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Statistics Section -->
    <section class="py-16 bg-horizon-700 text-white">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6 gap-8">
                <!-- UK Operating Centres -->
                <div class="text-center">
                    <div class="text-3xl md:text-4xl font-bold mb-2">
                        <span class="counter" data-count="175">0</span>
                    </div>
                    <p class="text-sm text-gray-300">UK operating centres</p>
                </div>

                <!-- Countries Worldwide -->
                <div class="text-center">
                    <div class="text-3xl md:text-4xl font-bold mb-2">
                        <span class="counter" data-count="120">0</span>
                    </div>
                    <p class="text-sm text-gray-300">Countries Worldwide</p>
                </div>

                <!-- Logistics Professionals -->
                <div class="text-center">
                    <div class="text-3xl md:text-4xl font-bold mb-2">
                        <span class="counter" data-count="50">0</span><span class="text-lg">K</span>
                    </div>
                    <p class="text-sm text-gray-300">Logistics Professionals</p>
                </div>

                <!-- Containers of Freight -->
                <div class="text-center">
                    <div class="text-3xl md:text-4xl font-bold mb-2">
                        <span class="counter" data-count="450">0</span><span class="text-lg">K</span>
                    </div>
                    <p class="text-sm text-gray-300">containers of freight</p>
                </div>

                <!-- Project Delivery Vehicles -->
                <div class="text-center">
                    <div class="text-3xl md:text-4xl font-bold mb-2">
                        <span class="counter" data-count="35">0</span><span class="text-lg">K</span>
                    </div>
                    <p class="text-sm text-gray-300">Project delivery vehicles</p>
                </div>

                <!-- Warehousing -->
                <div class="text-center">
                    <div class="text-3xl md:text-4xl font-bold mb-2">
                        <span class="counter" data-count="20">0</span><span class="text-lg">K</span>
                    </div>
                    <p class="text-sm text-gray-300">sq.ft of warehousing</p>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="py-16 bg-cover bg-center relative" style="background-image: linear-gradient(rgba(0, 0, 0, 0.7), rgba(0, 0, 0, 0.7)), url('images/section-bg-01.jpg')">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8 text-center text-white">
            <h2 class="text-3xl md:text-4xl font-display font-bold mb-4">
                We are now Logistics Industry Limited
            </h2>
            <p class="text-xl mb-8 text-white text-opacity-90">
                We're one of the UK's leading shipping and logistics providers.
            </p>
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                <a href="#" class="inline-flex items-center px-8 py-3 border border-transparent text-base font-medium rounded-md text-horizon-700 bg-gold-500 hover:bg-gold-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-gold-500 transition-colors duration-200">
                    Get A Quote
                </a>
                <a href="#calculator" class="inline-flex items-center px-8 py-3 border-2 border-white text-base font-medium rounded-md text-white bg-transparent hover:bg-white hover:text-horizon-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-white transition-colors duration-200">
                    Estimate Cost
                </a>
            </div>
        </div>
    </section>

    <!-- Cost Calculator Section -->
    <section id="calculator" class="py-16 bg-gray-50">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-12">
                <h6 class="text-gold-600 font-medium text-sm uppercase tracking-wide mb-2">TOTAL DELIVERY COST</h6>
                <h2 class="text-3xl md:text-4xl font-display font-bold text-horizon-800">
                    Find out the approximate cost of delivery of your shipments
                </h2>
            </div>

            <div class="bg-white rounded-lg shadow-sm p-8">
                <form class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                    <div>
                        <label class="block text-sm font-medium text-horizon-800 mb-2">Distance</label>
                        <select class="w-full px-4 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-gold-500 focus:border-gold-500">
                            <option>Please select</option>
                            <option>0-100 miles</option>
                            <option>100-500 miles</option>
                            <option>500+ miles</option>
                        </select>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-horizon-800 mb-2">Destination</label>
                        <input type="text" class="w-full px-4 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-gold-500 focus:border-gold-500" placeholder="Enter destination">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-horizon-800 mb-2">Width (cm)</label>
                        <input type="number" class="w-full px-4 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-gold-500 focus:border-gold-500" placeholder="0">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-horizon-800 mb-2">Height (cm)</label>
                        <input type="number" class="w-full px-4 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-gold-500 focus:border-gold-500" placeholder="0">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-horizon-800 mb-2">Weight (kg)</label>
                        <input type="number" class="w-full px-4 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-gold-500 focus:border-gold-500" placeholder="0">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-horizon-800 mb-2">Fragile</label>
                        <div class="flex items-center space-x-4">
                            <label class="flex items-center">
                                <input type="radio" name="fragile" value="yes" class="text-gold-500 focus:ring-gold-500">
                                <span class="ml-2 text-sm text-horizon-800">Yes</span>
                            </label>
                            <label class="flex items-center">
                                <input type="radio" name="fragile" value="no" checked class="text-gold-500 focus:ring-gold-500">
                                <span class="ml-2 text-sm text-horizon-800">No</span>
                            </label>
                        </div>
                    </div>

                    <div class="md:col-span-2">
                        <div class="space-y-2">
                            <label class="flex items-center">
                                <input type="checkbox" checked class="text-gold-500 focus:ring-gold-500">
                                <span class="ml-2 text-sm text-horizon-800">Express Delivery</span>
                            </label>
                            <label class="flex items-center">
                                <input type="checkbox" class="text-gold-500 focus:ring-gold-500">
                                <span class="ml-2 text-sm text-horizon-800">Insurance</span>
                            </label>
                            <label class="flex items-center">
                                <input type="checkbox" class="text-gold-500 focus:ring-gold-500">
                                <span class="ml-2 text-sm text-horizon-800">Packaging</span>
                            </label>
                        </div>
                    </div>
                    <div class="md:col-span-2 lg:col-span-4 text-right">
    <button type="button" id="calculateBtn" class="mt-4 px-6 py-2 bg-gold-600 text-white font-semibold rounded-md shadow hover:bg-gold-700">
        Calculate Cost
    </button>
</div>

                    <div class="md:col-span-2 lg:col-span-4">
                        <div class="flex items-center justify-between bg-gray-50 p-4 rounded-lg">
                            <span class="text-horizon-800 font-medium">Estimated Price:</span>
                            <span class="text-2xl font-bold text-gold-600">$0.000</span>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </section>

    <!-- Testimonials Section -->
    <section class="py-16 bg-white">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
                <!-- Testimonials -->
                <div>
                    <div class="testimonial-slider">
                        <div class="testimonial-item bg-gray-50 p-8 rounded-lg">
                            <p class="text-secondary-700 mb-6 italic">
                                "As a first time importer from the Far East, the process can be quite daunting. John Good has provided exceptional service and support right through the process."
                            </p>
                            <div>
                                <h6 class="font-semibold text-horizon-800">Steve Macholnad</h6>
                                <small class="text-secondary-600">Manager Smart Move LTD</small>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Client Logos -->
                <div>
                    <h2 class="text-3xl font-display font-bold text-horizon-800 mb-8">
                        Trusted By Some The World's Companies for over 180 years
                    </h2>
                    <div class="grid grid-cols-2 gap-6">
                        <div class="bg-gray-50 p-6 rounded-lg flex items-center justify-center">
                            <img src="temp/images/logo01.jpg" alt="Client Logo" class="max-h-12 w-auto opacity-60">
                        </div>
                        <div class="bg-gray-50 p-6 rounded-lg flex items-center justify-center">
                            <img src="temp/images/logo02.jpg" alt="Client Logo" class="max-h-12 w-auto opacity-60">
                        </div>
                        <div class="bg-gray-50 p-6 rounded-lg flex items-center justify-center">
                            <img src="temp/images/logo03.jpg" alt="Client Logo" class="max-h-12 w-auto opacity-60">
                        </div>
                        <div class="bg-gray-50 p-6 rounded-lg flex items-center justify-center">
                            <img src="temp/images/logo04.jpg" alt="Client Logo" class="max-h-12 w-auto opacity-60">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <script>
        $(document).ready(function() {
            // Hero Slider
            let currentSlide = 0;
            const slides = $('.hero-slide-item');
            const totalSlides = slides.length;
            const dots = $('.slider-dot');

            // Set first slide and dot as active
            slides.eq(0).show();
            dots.eq(0).addClass('bg-opacity-100');

            // Function to change slide
            function goToSlide(index) {
                // Hide current slide
                slides.eq(currentSlide).fadeOut(500);
                dots.eq(currentSlide).removeClass('bg-opacity-100').addClass('bg-opacity-50');

                // Show new slide
                currentSlide = index;
                slides.eq(currentSlide).fadeIn(500);
                dots.eq(currentSlide).removeClass('bg-opacity-50').addClass('bg-opacity-100');
            }

            // Auto-advance slides
            let slideInterval = setInterval(function() {
                const nextSlide = (currentSlide + 1) % totalSlides;
                goToSlide(nextSlide);
            }, 5000);

            // Click on dots to change slide
            dots.click(function() {
                const slideIndex = $(this).data('slide');
                if (slideIndex !== currentSlide) {
                    clearInterval(slideInterval);
                    goToSlide(slideIndex);

                    // Restart auto-advance
                    slideInterval = setInterval(function() {
                        const nextSlide = (currentSlide + 1) % totalSlides;
                        goToSlide(nextSlide);
                    }, 5000);
                }
            });

            // Navigation arrows
            $('#prev-slide').click(function() {
                const prevSlide = (currentSlide - 1 + totalSlides) % totalSlides;
                clearInterval(slideInterval);
                goToSlide(prevSlide);

                slideInterval = setInterval(function() {
                    const nextSlide = (currentSlide + 1) % totalSlides;
                    goToSlide(nextSlide);
                }, 5000);
            });

            $('#next-slide').click(function() {
                const nextSlide = (currentSlide + 1) % totalSlides;
                clearInterval(slideInterval);
                goToSlide(nextSlide);

                slideInterval = setInterval(function() {
                    const nextSlide = (currentSlide + 1) % totalSlides;
                    goToSlide(nextSlide);
                }, 5000);
            });

            // Counter Animation
            function animateCounters() {
                $('.counter').each(function() {
                    var $this = $(this);
                    var countTo = parseInt($this.attr('data-count'));

                    $({ countNum: 0 }).animate({
                        countNum: countTo
                    }, {
                        duration: 2000,
                        easing: 'swing',
                        step: function() {
                            $this.text(Math.floor(this.countNum));
                        },
                        complete: function() {
                            $this.text(countTo);
                        }
                    });
                });
            }

            // Trigger counter animation when section is visible
            function checkCounters() {
                const counterSection = $('.counter').first().closest('section');
                if (counterSection.length) {
                    const sectionTop = counterSection.offset().top;
                    const sectionHeight = counterSection.outerHeight();
                    const windowTop = $(window).scrollTop();
                    const windowHeight = $(window).height();

                    if (windowTop + windowHeight > sectionTop + 100) {
                        animateCounters();
                        $(window).off('scroll', checkCounters); // Remove listener after animation
                    }
                }
            }

            $(window).on('scroll', checkCounters);
        });
    </script>
        </div>
    </main>


<script>
document.addEventListener("DOMContentLoaded", () => {
    const distanceSelect = document.querySelector("select");
    const widthInput = document.querySelectorAll('input[placeholder="0"]')[0];
    const heightInput = document.querySelectorAll('input[placeholder="0"]')[1];
    const weightInput = document.querySelectorAll('input[placeholder="0"]')[2];
    const fragileInputs = document.querySelectorAll('input[name="fragile"]');
    const checkboxes = document.querySelectorAll('input[type="checkbox"]');
    const priceSpan = document.querySelector(".text-2xl.font-bold.text-gold-600");
    const calculateBtn = document.getElementById("calculateBtn");

    function calculatePrice() {
        let distanceCost = 0;
        const distance = distanceSelect.value;

        if (distance === "0-100 miles") distanceCost = 100;
        else if (distance === "100-500 miles") distanceCost = 250;
        else if (distance === "500+ miles") distanceCost = 500;

        const width = parseFloat(widthInput.value) || 0;
        const height = parseFloat(heightInput.value) || 0;
        const weight = parseFloat(weightInput.value) || 0;

        const volumeFee = (width * height) / 500;
        const weightFee = weight * 1.5;

        const isFragile = [...fragileInputs].find(input => input.checked)?.value === "yes";
        const fragileFee = isFragile ? 10 : 0;

        const express = checkboxes[0].checked ? 1.2 : 1;
        const insuranceFee = checkboxes[1].checked ? 5 : 0;
        const packagingFee = checkboxes[2].checked ? 3 : 0;

        const total = (distanceCost + volumeFee + weightFee + fragileFee + insuranceFee + packagingFee) * express;

        priceSpan.textContent = `$${total.toFixed(3)}`;
    }

    calculateBtn.addEventListener("click", calculatePrice);
});
</script>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/quickdem/public_html/swifx/resources/views/home/index.blade.php ENDPATH**/ ?>