<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title><?php echo e($settings->site_name); ?></title>

    <link href="temp/custom/css/bootstrap.min.css" rel="stylesheet">
    
    
    
    <link href="temp/custom/css/style.css" rel="stylesheet">
    
    <link rel="shortcut icon" href="<?php echo e(asset('storage/app/public/' . $settings->favicon)); ?>" type="image/x-icon">
    <link rel="icon" href="<?php echo e(asset('storage/app/public/' . $settings->favicon)); ?>" type="image/x-icon">

    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">

</head>

<body>
    <div class="page-wrapper">

        

        <header class="main-header header-style-two">

            <div class="header-top" style="background-color: #fb7405;">
                <div class="inner-container">
                    <div class="top-left">

                        <ul class="list-style-one light">
                            <li><i class="fa fa-map-marker-alt"></i> <?php echo e($settings->locations); ?></li>
                            <li><i class="fa fa-clock"></i> Mon - Sat: 8am - 5pm</li>
                            <li><i class="fa fa-phone"></i> <a
                                    href="tel:<?php echo e($settings->whatsapp); ?>"><?php echo e($settings->whatsapp); ?></a></li>
                        </ul>
                    </div>
                    <div class="top-right">
                        <ul class="feature-ilst">
                            <!-- <li><a href="#">Help</a></li>
                            <li><a href="#">Track Now</a></li>
                            <li><a href="#">Support</a></li> -->
                        </ul>
                    </div>
                </div>
            </div>

            <div class="header-lower">

                <div class="main-box">
                    <div class="logo-box">
                        <div class="logo"><a href="/"><img
                                    src="<?php echo e(asset('storage/app/public/' . $settings->logo)); ?>" width="200"
                                    alt="Logo" title="Lozics"></a></div>
                    </div>

                    <div class="nav-outer">
                        <nav class="nav main-menu">
                            <ul class="navigation">
                                <li><a href="/">Home</a></li>

                                <li><a href="about">About</a></li>

                                <li><a href="services">Services</a></li>


                                <li><a href="contact">Contact</a></li>

                                <li><a href="track-order">Track & Trace</a></li>

                            </ul>
                        </nav>
                    </div>


                    <div class="outer-box">


                        <div class="btn-box">
                            <a href="track-order" class="theme-btn btn-style-one orange-bg"><span
                                    class="btn-title">Track & Trace</span></a>
                        </div>

                        <div class="mobile-nav-toggler"><span class="icon lnr-icon-bars"></span></div>
                    </div>
                </div>
            </div>

            <div class="mobile-menu">
                <div class="menu-backdrop"></div>

                <nav class="menu-box">
                    <div class="upper-box">
                        <div class="nav-logo"><a href="/"><img
                                    src="<?php echo e(asset('storage/app/public/' . $settings->logo)); ?>" alt="Logo"
                                    title="Lozics"></a></div>
                        <div class="close-btn"><i class="icon fa fa-times"></i></div>
                    </div>
                    <ul class="navigation clearfix">

                    </ul>
                    <ul class="contact-list-one">
                        <li>
                            <i class="icon lnr-icon-phone-handset"></i>
                            <span class="title">Call Now</span>
                            <div class="text"><a href="tel:<?php echo e($settings->whatsapp); ?>"><?php echo e($settings->whatsapp); ?></a>
                            </div>
                        </li>
                        <li>
                            <i class="icon lnr-icon-envelope1"></i>
                            <span class="title">Send Email</span>
                            <div class="text"><a href=""><span
                                        class="__cf_email__"><?php echo e($settings->contact_email); ?></span></a>
                            </div>
                        </li>
                        <li>
                            <i class="icon lnr-icon-map-marker"></i>
                            <span class="title">Address</span>
                            <div class="text"><?php echo e($settings->locations); ?></div>
                        </li>
                    </ul>
                    <ul class="social-links">
                        <li><a href="#"><i class="fab fa-twitter"></i></a></li>
                        <li><a href="#"><i class="fab fa-facebook-f"></i></a></li>
                        <li><a href="#"><i class="fab fa-pinterest"></i></a></li>
                        <li><a href="#"><i class="fab fa-instagram"></i></a></li>
                    </ul>
                </nav>
            </div>

            <div class="search-popup">
                <span class="search-back-drop"></span>
                <button class="close-search"><span class="fa fa-times"></span></button>
                <div class="search-inner">
                    <form method="post" action="#">
                        <div class="form-group">
                            <input type="search" name="search-field" value placeholder="Search..." required>
                            <button type="submit"><i class="fa fa-search"></i></button>
                        </div>
                    </form>
                </div>
            </div>


            <div class="sticky-header">
                <div class="auto-container">
                    <div class="inner-container">

                        <div class="logo">
                            <a href="/"><img src="<?php echo e(asset('storage/app/public/' . $settings->logo)); ?>"
                                    alt="Logo"title="Lozics" width="200" height="300"></a>
                        </div>

                        <div class="nav-outer">

                            <nav class="main-menu">
                                <div class="navbar-collapse show collapse clearfix">
                                    <ul class="navigation clearfix">

                                    </ul>
                                </div>
                            </nav>

                            <div class="mobile-nav-toggler"><span class="icon lnr-icon-bars"></span></div>
                        </div>
                    </div>
                </div>
            </div>
        </header>

        <?php echo $__env->yieldContent('content'); ?>

        <footer class="main-footer footer-style-one">
            <div class="bg bg-image" style="background-image: url(temp/custom/images/background/4.jpg);"></div>

            <div class="footer-top">
                <div class="auto-container">
                    <div class="outer-box">
                        <ul class="contact-list-two light">
                            <li>
                                <i class="icon flaticon-global-shipping-1"></i>
                                <div class="text">Address <br /> <span><?php echo e($settings->locations); ?> </span></div>
                            </li>
                            <li>
                                <i class="icon flaticon-stock-1"></i>
                                <div class="text">Contact <br /> <a
                                        href="mailto:<?php echo e($settings->email); ?>"><?php echo e($settings->email); ?></a></span></a>
                                    <a href="tel:<?php echo e($settings->whatsapp); ?>"><?php echo e($settings->whatsapp); ?></a>
                                </div>
                            </li>
                            <li>
                                <i class="icon flaticon-24-hours-2"></i>
                                <div class="text">Timing <br /> <span>Mon - Sat: 8 am - 5 pm, <br />Sunday:
                                        CLOSED</span></div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="widgets-section">
                <div class="auto-container">
                    <div class="row">

                        <div class="footer-column col-lg-3 col-sm-6">
                            <div class="footer-widget about-widget">
                                <div class="logo"><a href="#"><img
                                            src="<?php echo e(asset('storage/app/public/' . $settings->favicon)); ?>"
                                            alt="Logo"></a></div>
                                <div class="text">We work with a passion of taking challenges and creating new ones
                                    in
                                    advertising sector.</div>
                                <a href="about" class="theme-btn btn-style-one"><span class="btn-title">About
                                        Us</span></a>
                            </div>
                        </div>

                        <div class="footer-column col-lg-3 col-sm-6">
                            <div class="footer-widget links-widget">
                                <h4 class="widget-title">Service</h4>
                                <div class="widget-content">
                                    <ul class="user-links">
                                        <li><i class="icon fa fa-angle-double-right"></i> <a
                                                href="#">Reliability &
                                                Punctuality</a></li>
                                        <li><i class="icon fa fa-angle-double-right"></i> <a href="#">Trusted
                                                Franchise</a></li>
                                        <li><i class="icon fa fa-angle-double-right"></i> <a href="#">Warehoues
                                                Storage</a></li>
                                        <li><i class="icon fa fa-angle-double-right"></i> <a href="#">Real Time
                                                Tracking</a></li>
                                        <li><i class="icon fa fa-angle-double-right"></i> <a
                                                href="#">Transparent
                                                Pricing</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>

                        <div class="footer-column col-lg-3 col-sm-6">
                            <div class="footer-widget gallery-widget">
                                <h4 class="widget-title">Projects</h4>
                                <div class="widget-content">
                                    <div class="insta-gallery">
                                        <figure class="image"><a href="#"><img
                                                    src="temp/custom/images/resource/gallery-thumb-1.jpg"
                                                    alt="Image"></a></figure>
                                        <figure class="image"><a href="#"><img
                                                    src="temp/custom/images/resource/gallery-thumb-2.jpg"
                                                    alt="Image"></a></figure>
                                        <figure class="image"><a href="#"><img
                                                    src="temp/custom/images/resource/gallery-thumb-3.jpg"
                                                    alt="Image"></a></figure>
                                        <figure class="image"><a href="#"><img
                                                    src="temp/custom/images/resource/gallery-thumb-4.jpg"
                                                    alt="Image"></a></figure>
                                        <figure class="image"><a href="#"><img
                                                    src="temp/custom/images/resource/gallery-thumb-5.jpg"
                                                    alt="Image"></a></figure>
                                        <figure class="image"><a href="#"><img
                                                    src="temp/custom/images/resource/gallery-thumb-6.jpg"
                                                    alt="Image"></a></figure>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="footer-column col-lg-3 col-sm-6">
                            <div class="footer-widget newsletter-widget">
                                <h4 class="widget-title">Newsletter</h4>
                                <div class="text">Subscribe our newsletter to get our latest update & news</div>

                                <div class="newsletter-form">
                                    <div class="form-group">
                                        <input type="email" name="Email" placeholder="Email....." required>
                                        <button type="submit" class="form-btn"><i
                                                class="fa fa-paper-plane"></i></button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="footer-bottom">
                <div class="auto-container">
                    <div class="inner-container">
                        <div class="scroll-to-top scroll-to-target" data-target="html"><span
                                class="fa fa-angle-up"></span></div>
                        <div class="copyright-text">© Copyright 2024 by <?php echo e($settings->site_name); ?></div>
                        <ul class="social-icon-one light">
                            <li><a href="#"><i class="fab fa-facebook"></i></a></li>
                            <li><a href="#"><i class="fab fa-twitter"></i></a></li>
                            <li><a href="#"><i class="fab fa-pinterest-p"></i></a></li>
                            <li><a href="#"><i class="fab fa-instagram"></i></a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </footer>

    </div>
    <script data-cfasync="false" src="https://cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.html"></script>
    <script src="temp/custom/js/jquery.js"></script>
    <script src="temp/custom/js/popper.min.js"></script>

    <script src="temp/custom/plugins/revolution/js/jquery.themepunch.revolution.min.js"></script>
    <script src="temp/custom/plugins/revolution/js/jquery.themepunch.tools.min.js"></script>
    <script src="temp/custom/plugins/revolution/js/extensions/revolution.extension.actions.min.js"></script>
    <script src="temp/custom/plugins/revolution/js/extensions/revolution.extension.carousel.min.js"></script>
    <script src="temp/custom/plugins/revolution/js/extensions/revolution.extension.kenburn.min.js"></script>
    <script src="temp/custom/plugins/revolution/js/extensions/revolution.extension.layeranimation.min.js"></script>
    <script src="temp/custom/plugins/revolution/js/extensions/revolution.extension.migration.min.js"></script>
    <script src="temp/custom/plugins/revolution/js/extensions/revolution.extension.navigation.min.js"></script>
    <script src="temp/custom/plugins/revolution/js/extensions/revolution.extension.parallax.min.js"></script>
    <script src="temp/custom/plugins/revolution/js/extensions/revolution.extension.slideanims.min.js"></script>
    <script src="temp/custom/plugins/revolution/js/extensions/revolution.extension.video.min.js"></script>
    <script src="temp/custom/js/main-slider-script.js"></script>

    <script src="temp/custom/js/bootstrap.min.js"></script>
    <script src="temp/custom/js/jquery.fancybox.js"></script>
    <script src="temp/custom/js/jquery-ui.js"></script>
    <script src="temp/custom/js/wow.js"></script>
    <script src="temp/custom/js/appear.js"></script>
    <script src="temp/custom/js/gsap.min.js"></script>
    <script src="temp/custom/js/ScrollTrigger.min.js"></script>
    <script src="temp/custom/js/splitType.js"></script>
    <script src="temp/custom/js/select2.min.js"></script>
    <script src="temp/custom/js/odometer.js"></script>
    <script src="temp/custom/js/owl.js"></script>
    <script src="temp/custom/js/script.js"></script>


    <?php if($settings->tido): ?>
        <script src="//code.tidio.co/<?php echo e($settings->tido); ?>.js" async></script>
    <?php endif; ?>


    <!-- GetButton.io widget -->
    <?php if($settings->whatsapp): ?>
        <script type="text/javascript">
            (function() {
                var options = {
                    whatsapp: "<?php echo e($settings->whatsapp); ?>", // WhatsApp number
                    call_to_action: "Message us", // Call to action
                    button_color: "#FF6550", // Color of button
                    position: "left", // Position may be 'right' or 'left'
                };
                var proto = 'https:',
                    host = "getbutton.io",
                    url = proto + '//static.' + host;
                var s = document.createElement('script');
                s.type = 'text/javascript';
                s.async = true;
                s.src = url + '/widget-send-button/js/init.js';
                s.onload = function() {
                    WhWidgetSendButton.init(host, proto, options);
                };
                var x = document.getElementsByTagName('script')[0];
                x.parentNode.insertBefore(s, x);
            })();
        </script>
    <?php endif; ?>
</body>

</html>
<?php /**PATH C:\xampp\htdocs\protarck\resources\views/layouts/base1.blade.php ENDPATH**/ ?>