<?php $__env->startComponent('mail::message'); ?>
# Shipment Created – Tracking <?php echo e($courier->tracking_code); ?>


Dear <?php echo e($courier->receiver_name); ?>,

A shipment has been created for you.

**From:** <?php echo e($courier->sender_name); ?> (<?php echo e($courier->sender_email); ?>)
**To:** <?php echo e($courier->receiver_name); ?> (<?php echo e($courier->receiver_email); ?>)
**Origin:** <?php echo e($courier->origin); ?>

**Destination:** <?php echo e($courier->destination); ?>

**Status:** <?php echo e($courier->status); ?>

**Estimated Delivery:** <?php echo e(\Carbon\Carbon::parse($courier->estimated_delivery)->toFormattedDateString()); ?>


<?php $__env->startComponent('mail::button', ['url' => route('track.form')]); ?>
Track Your Shipment
<?php echo $__env->renderComponent(); ?>

Thanks,
**<?php echo e(config('app.name')); ?> Team**
<?php echo $__env->renderComponent(); ?>

<?php /**PATH /home/swizzfx/tracking1.swizzfx.pro/resources/views/emails/couriers/courier_created.blade.php ENDPATH**/ ?>